<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin"><?php echo _l('edit_team_group'); ?></h4>
                        <hr class="hr-panel-heading" />
                        <?php echo form_open(admin_url('team_group/save_group'), ['id' => 'team-group-form']); ?>
                        <input type="hidden" name="id" value="<?php echo html_escape($group->id); ?>">

                        <div class="form-group">
                            <?php echo render_input('group_name', 'group_name', $group->group_name); ?>
                        </div>

                        <div class="form-group">
                            <label for="managers"><?php echo _l('select_manager'); ?></label>
                            <select name="managers[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
                                <?php foreach ($staff_members as $member) { ?>
                                    <option value="<?php echo $member['staffid']; ?>" <?php echo (in_array($member['staffid'], json_decode($group->manager_ids, true))) ? 'selected' : ''; ?>>
                                        <?php echo get_staff_full_name($member['staffid']); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="tls"><?php echo _l('select_tl'); ?></label>
                            <select name="team_leaders[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
                                <?php foreach ($staff_members as $member) { ?>
                                    <option value="<?php echo $member['staffid']; ?>" <?php echo (in_array($member['staffid'], json_decode($group->tl_ids, true))) ? 'selected' : ''; ?>>
                                        <?php echo get_staff_full_name($member['staffid']); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="status"><?php echo _l('status'); ?></label>
                            <select name="status" class="selectpicker" data-width="100%">
                                <option value="Active" <?php echo (strtolower($group->status) == 'active') ? 'selected' : ''; ?>><?php echo _l('active'); ?></option>
                                <option value="Inactive" <?php echo (strtolower($group->status) == 'inactive') ? 'selected' : ''; ?>><?php echo _l('inactive'); ?></option>
                            </select>

                        </div>


                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
    $(function() {
        appValidateForm($('#team-group-form'), {
            group_name: 'required',
            managers: 'required',
            status: 'required'
        });
    });
</script>