<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin"><?php echo _l('edit_sub_group'); ?></h4>
                        <hr class="hr-panel-heading" />
                        <?php echo form_open(admin_url('team_group/save_sub_group'), ['id' => 'sub-group-form']); ?>
                        <input type="hidden" name="id" value="<?php echo e($sub_group['id']); ?>">
                        <div class="form-group">
                            <?php echo render_input('sub_group_name', 'sub_group_name', e($sub_group['sub_group_name'])); ?>
                        </div>
                        <div class="form-group">
                            <label for="group_id"><?php echo _l('select_team_groups'); ?></label>
                            <select name="group_id" id="group_id" class="selectpicker" data-live-search="true" data-width="100%" required>
                                <option value=""><?php echo _l('select_option'); ?></option>
                                <?php foreach ($team_groups as $group) { ?>
                                    <option value="<?php echo $group->id; ?>" <?php echo ($sub_group['team_group_id'] == $group->id) ? 'selected' : ''; ?>>
                                        <?php echo e($group->group_name); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="sub_group_manager"><?php echo _l('sub_group_manager'); ?></label>
                            <input type="text" name="sub_group_manager" id="sub_group_manager" class="form-control" readonly
                                   value="<?php echo e(implode(', ', $sub_group['manager_names'])); ?>">
                            <input type="hidden" name="sub_group_manager_ids" id="sub_group_manager_ids"
                                   value="<?php echo e($sub_group['sub_group_manager']); ?>">
                        </div>
                        <div class="form-group">
                            <label for="team_leaders"><?php echo _l('select_team_leaders'); ?></label>
                            <select name="team_leaders[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
                                <?php foreach ($staff_members as $member) { ?>
                                    <option value="<?php echo $member['staffid']; ?>" <?php echo (in_array($member['staffid'], json_decode($sub_group['tl_ids'] ?? '[]'))) ? 'selected' : ''; ?>>
                                        <?php echo e(get_staff_full_name($member['staffid'])); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="employees"><?php echo _l('select_employees'); ?></label>
                            <select name="employees[]" class="selectpicker" multiple data-live-search="true" data-width="100%" required>
                                <?php foreach ($staff_members as $member) { ?>
                                    <option value="<?php echo $member['staffid']; ?>" <?php echo (in_array($member['staffid'], json_decode($sub_group['employee_ids'] ?? '[]'))) ? 'selected' : ''; ?>>
                                        <?php echo e(get_staff_full_name($member['staffid'])); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="clients"><?php echo _l('select_clients'); ?></label>
                            <select name="clients[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
                                <?php
                                    $this->db->select('userid, company');
                                    $this->db->from(db_prefix() . 'clients');
                                    $clients = $this->db->get()->result_array();
                                    foreach ($clients as $client) { ?>
                                        <option value="<?php echo $client['userid']; ?>" <?php echo (in_array($client['userid'], json_decode($sub_group['client'] ?? '[]'))) ? 'selected' : ''; ?>>
                                            <?php echo e($client['company'] ?: 'Client #' . $client['userid']); ?>
                                        </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="consultant"><?php echo _l('select_consultant'); ?></label>
                            <select name="consultant[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
                                <?php foreach ($staff_members as $member) { ?>
                                    <option value="<?php echo $member['staffid']; ?>" <?php echo (in_array($member['staffid'], json_decode($sub_group['consultant'] ?? '[]'))) ? 'selected' : ''; ?>>
                                        <?php echo e(get_staff_full_name($member['staffid'])); ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="status"><?php echo _l('status'); ?></label>
                            <select name="status" class="selectpicker" data-width="100%" required>
                                <option value="Active" <?php echo ($sub_group['status'] == 'Active') ? 'selected' : ''; ?>><?php echo _l('active'); ?></option>
                                <option value="Inactive" <?php echo ($sub_group['status'] == 'Inactive') ? 'selected' : ''; ?>><?php echo _l('inactive'); ?></option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
    $('.selectpicker').selectpicker();
    appValidateForm($('#sub-group-form'), {
        sub_group_name: 'required',
        group_id: 'required',
        employees: 'required',
        status: 'required'
    });
    $('#group_id').on('change', function() {
        var group_id = $(this).val();
        if (group_id) {
            $.ajax({
                url: '<?php echo admin_url('team_group/get_group_managers'); ?>',
                type: 'POST',
                data: { group_id: group_id },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $('#sub_group_manager').val(response.manager_names);
                        $('#sub_group_manager_ids').val(response.manager_ids);
                    } else {
                        $('#sub_group_manager').val('');
                        $('#sub_group_manager_ids').val('[]');
                    }
                },
                error: function() {
                    $('#sub_group_manager').val('');
                    $('#sub_group_manager_ids').val('[]');
                    alert('Error fetching managers');
                }
            });
        } else {
            $('#sub_group_manager').val('');
            $('#sub_group_manager_ids').val('[]');
        }
    });
    $('#group_id').trigger('change');
});
</script>