<?php

file_put_contents(FCPATH . 'modules/team_group/views/tables/test_log.txt', "Loaded team_groups table file\n", FILE_APPEND);

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = ['id', 'group_name', 'manager_ids', 'tl_ids', 'status'];
$sIndexColumn = 'id';
$sTable = db_prefix() . 'team_groups';

$join = [];
$where = [];

// Restrict access for non-admins
if (!is_admin()) {
    $staff_id = (string) get_staff_user_id();
    $where[] = "AND (
        JSON_CONTAINS(manager_ids, '\"$staff_id\"')
        OR JSON_CONTAINS(tl_ids, '\"$staff_id\"')
    )";
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where);
$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    // ID
    $row[] = $aRow['id'];

    // Group Name
    $row[] = $aRow['group_name'];

    // Manager Names
    $manager_names = [];
    if (!empty($aRow['manager_ids'])) {
        $decoded = json_decode($aRow['manager_ids'], true);
        if (is_array($decoded)) {
            foreach ($decoded as $id) {
                $name = get_staff_full_name($id);
                if ($name) {
                    $manager_names[] = $name;
                }
            }
        }
    }
    $row[] = implode(', ', $manager_names);

    // Team Leader Names
    $tl_names = [];
    if (!empty($aRow['tl_ids'])) {
        $decoded = json_decode($aRow['tl_ids'], true);
        if (is_array($decoded)) {
            foreach ($decoded as $id) {
                $name = get_staff_full_name($id);
                if ($name) {
                    $tl_names[] = $name;
                }
            }
        }
    }
    $row[] = implode(', ', $tl_names);

    // Status
    $status_value = isset($aRow['status']) ? strtolower($aRow['status']) : 'inactive';
    $status_label = ($status_value === 'active') ? 'success' : 'danger';
    $status_text = ($status_value === 'active') ? _l('active') : _l('inactive');
    $row[] = '<span class="label label-' . $status_label . '">' . $status_text . '</span>';

    // Options (Edit/Delete)
    $edit_url = admin_url('team_group/edit/' . $aRow['id']);
    $delete_url = admin_url('team_group/delete/' . $aRow['id']);

    $options = '<a href="' . $edit_url . '" class="btn btn-default btn-icon"><i class="fa fa-edit"></i></a>';
    $options .= ' <a href="' . $delete_url . '" class="btn btn-danger btn-icon _delete"><i class="fa fa-trash"></i></a>';

    $row[] = $options;

    $output['aaData'][] = $row;
}

return $output;
