<?php
defined('BASEPATH') or exit('No direct script access allowed');

log_message('debug', 'web_to_team_group_data.php called with form_id: ' . $this->input->get('form_id'));

$aColumns = ['id', 'field_label', 'field_value', 'field_type', 'dateadded'];
$sIndexColumn = 'id';
$sTable = db_prefix() . 'kpi_form_list';

$form_id = $this->input->get('form_id');
if (!$form_id) {
    log_message('error', 'No form_id provided');
    echo json_encode(['aaData' => []]);
    exit;
}

$this->db->where('form_id', $form_id);
$result = $this->db->get($sTable);
log_message('debug', 'Query: ' . $this->db->last_query());
log_message('debug', 'Rows found: ' . $result->num_rows());

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, [], ['form_id' => $form_id], ['id']);
$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == 'dateadded') {
            $_data = '<span class="text-has-action is-date" data-toggle="tooltip" data-title="' . e(_dt($_data)) . '">' . e(time_ago($_data)) . '</span>';
        } else {
            $_data = e($_data);
        }
        $row[] = $_data;
    }
    $output['aaData'][] = $row;
}

log_message('debug', 'DataTables output: ' . json_encode($output));
echo json_encode($output);