<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="tw-mb-2">
                    <a href="<?php echo admin_url('team_group/report'); ?>" class="btn btn-default">
                        <i class="fa fa-arrow-left tw-mr-1"></i>
                        <?php echo _l('back'); ?>
                    </a>
                </div>
                <div class="panel_s">
                    <div class="panel-body panel-table-full">
                        <h4 class="no-margin"><?php echo e($title); ?></h4>
                        <hr class="hr-panel-heading" />
 
                        <?php
                        $this->load->model('team_group_model');
                        $pivot = $this->team_group_model->get_pivoted_form_submissions($form->id);
                        $columns = $pivot['columns'];
 
                        $thead_columns = array_merge(
                            ['ID', 'Form ID'], // Added ID
                            $columns,
                            ['Submission Date']
                        );
 
                        render_datatable($thead_columns, 'web-to-team-group-data');
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
 
<!-- Modal -->
<div class="modal fade" id="submissionModal" tabindex="-1" role="dialog" aria-labelledby="submissionModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="submissionModalLabel">Submission Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table class="table table-bordered" id="submissionDetailsTable">
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>
</div>
 
<?php init_tail(); ?>
<script>
$(function () {
    initDataTable('.table-web-to-team-group-data', '<?php echo admin_url('team_group/view_form_data_table/' . $form->id); ?>');
 
    $(document).on('click', '.view-submission', function () {
        var id = $(this).data('id');
 
        $.get('<?php echo admin_url('team_group/get_submission_details/'); ?>' + id, function (response) {
            var res = JSON.parse(response);
            if (res.error) {
                alert(res.error);
                return;
            }
 
            var html = '';
            html += '<tr><th>ID</th><td>' + res.id + '</td></tr>';
            html += '<tr><th>Form ID</th><td>' + res.form_id + '</td></tr>';
            html += '<tr><th>Date Added</th><td>' + res.dateadded + '</td></tr>';
 
            $.each(res.submitted_data, function (key, value) {
                html += '<tr><th>' + key + '</th><td style="white-space: pre-wrap;">' + value + '</td></tr>';
            });
 
            $('#submissionDetailsTable tbody').html(html);
            $('#submissionModal').modal('show');
        });
    });
});
</script>
</body>
</html>
 
 