<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Return group status label.
 * 
 * @param  string $status
 * @return string
 */
function format_group_status($status)
{
    if ($status == 'active') {
        return '<span class="label label-success">' . _l('active') . '</span>';
    } elseif ($status == 'inactive') {
        return '<span class="label label-danger">' . _l('inactive') . '</span>';
    }

    return '';
}

/**
 * Returns staff names by their IDs (comma separated).
 * 
 * @param  array $staff_ids
 * @return string
 */
function get_staff_names_by_ids($staff_ids)
{
    $CI =& get_instance();
    $CI->load->model('staff_model');

    if (!is_array($staff_ids)) {
        $staff_ids = explode(',', $staff_ids);
    }

    $names = [];
    foreach ($staff_ids as $id) {
        $staff = $CI->staff_model->get($id);
        if ($staff) {
            $names[] = get_staff_full_name($staff->staffid);
        }
    }

    return implode(', ', $names);
}

/**
 * Safely JSON encode/decode checkbox staff fields.
 * 
 * @param  mixed $value
 * @param  bool  $decode
 * @return mixed
 */
function handle_multi_staff_field($value, $decode = false)
{
    return $decode ? json_decode($value, true) : json_encode(array_filter($value));
}
