<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin">
      <?php echo isset($group) ? _l('edit_team_group') : _l('create_team_group'); ?>
    </h4>
    <hr class="hr-panel-heading" />

    <?php echo form_open(admin_url('team_group/save_group'), ['id' => 'team-group-form']); ?>

    <?php echo form_hidden('id', isset($group) ? $group['id'] : ''); ?>

    <div class="form-group">
      <label for="group_name"><?php echo _l('group_name'); ?></label>
      <input type="text" name="group_name" class="form-control" value="<?php echo isset($group) ? e($group['group_name']) : ''; ?>" required>
    </div>

    <div class="form-group">
      <label for="managers"><?php echo _l('select_managers'); ?></label>
      <select name="managers[]" class="form-control selectpicker" multiple data-live-search="true" required>
        <?php foreach ($staff as $member) { ?>
          <option value="<?php echo $member['staffid']; ?>" <?php echo (isset($group) && in_array($member['staffid'], explode(',', $group['managers']))) ? 'selected' : ''; ?>>
            <?php echo get_staff_full_name($member['staffid']); ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <div class="form-group">
      <label for="team_leaders"><?php echo _l('select_tl'); ?></label>
      <select name="team_leaders[]" class="form-control selectpicker" multiple data-live-search="true" required>
        <?php foreach ($staff as $member) { ?>
          <option value="<?php echo $member['staffid']; ?>" <?php echo (isset($group) && in_array($member['staffid'], explode(',', $group['team_leaders']))) ? 'selected' : ''; ?>>
            <?php echo get_staff_full_name($member['staffid']); ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <div class="form-group">
      <label for="status"><?php echo _l('status'); ?></label>
      <select name="status" class="form-control selectpicker" required>
        <option value="Active" <?php echo (isset($group) && $group['status'] == 'Active') ? 'selected' : ''; ?>><?php echo _l('active'); ?></option>
        <option value="Inactive" <?php echo (isset($group) && $group['status'] == 'Inactive') ? 'selected' : ''; ?>><?php echo _l('inactive'); ?></option>
      </select>
    </div>

    <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
    <a href="<?php echo admin_url('team_group'); ?>" class="btn btn-default"><?php echo _l('cancel'); ?></a>

    <?php echo form_close(); ?>
  </div>
</div>
