<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php echo form_open(admin_url('team_group/save_group'), ['id' => 'team-group-form']); ?>

<div class="panel_s">
  <div class="panel-body">
    <h4 class="no-margin">
      <?php echo isset($group) ? _l('edit_team_group') : _l('create_team_group'); ?>
    </h4>
    <hr class="hr-panel-heading" />

    <div class="form-group">
      <?php echo render_input('group_name', 'group_name', isset($group) ? $group['group_name'] : ''); ?>
    </div>

    <div class="form-group">
      <label for="managers"><?php echo _l('select_manager'); ?></label>
      <select name="managers[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
        <?php foreach ($staff as $member) { ?>
          <option value="<?php echo $member['staffid']; ?>" <?php echo (isset($group) && in_array($member['staffid'], explode(',', $group['managers']))) ? 'selected' : ''; ?>>
            <?php echo get_staff_full_name($member['staffid']); ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <div class="form-group">
      <label for="tls"><?php echo _l('select_tl'); ?></label>
      <select name="tls[]" class="selectpicker" multiple data-live-search="true" data-width="100%">
        <?php foreach ($staff as $member) { ?>
          <option value="<?php echo $member['staffid']; ?>" <?php echo (isset($group) && in_array($member['staffid'], explode(',', $group['tls']))) ? 'selected' : ''; ?>>
            <?php echo get_staff_full_name($member['staffid']); ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <div class="form-group">
      <label for="status"><?php echo _l('status'); ?></label>
      <select name="status" class="selectpicker" data-width="100%">
        <option value="Active" <?php echo (isset($group) && $group['status'] == 'Active') ? 'selected' : ''; ?>><?php echo _l('active'); ?></option>
        <option value="Inactive" <?php echo (isset($group) && $group['status'] == 'Inactive') ? 'selected' : ''; ?>><?php echo _l('inactive'); ?></option>
      </select>
    </div>

    <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
  </div>
</div>

<?php echo form_close(); ?>
