<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div role="tabpanel" class="tab-pane" id="home_deals_tab">
  <a href="<?php echo admin_url('deals'); ?>" class="mbot20 inline-block full-width"><?php echo _l('home_widget_view_all'); ?></a>
  <div class="clearfix"></div>
  <div class="table-responsive">
    <table class="table table-bordered">
      <thead>
        <tr>
          <th><?php echo _l('the_number_sign'); ?></th>
          <th><?php echo _l('deal_name'); ?></th>
          <th><?php echo _l('company'); ?></th>
          <th><?php echo _l('deal_value'); ?></th>
          <th><?php echo _l('pipeline'); ?></th>
          <th><?php echo _l('stage'); ?></th>
          <th><?php echo _l('status'); ?></th>
          <th><?php echo _l('dateadded'); ?></th>
        </tr>
      </thead>
      <tbody>
        <?php if (!empty($dashboard_deals)) { foreach ($dashboard_deals as $d) { ?>
          <tr>
            <td><a href="<?php echo admin_url('deals/view/' . (int)$d['id']); ?>" class="tw-font-medium"><?php echo (int)$d['id']; ?></a></td>
            <td><?php echo html_entity_decode($d['name']); ?></td>
            <td><?php echo html_entity_decode($d['company']); ?></td>
            <td><?php echo function_exists('app_format_money') && isset($base_currency->id) ? app_format_money((float)$d['deal_value'], $base_currency->id) : (float)$d['deal_value']; ?></td>
            <td><?php echo html_entity_decode($d['pipeline_name'] ?? ''); ?></td>
            <td><?php echo html_entity_decode($d['stage_name'] ?? ''); ?></td>
            <td><?php echo ucfirst($d['status_final']); ?></td>
            <td><span class="text-has-action" data-toggle="tooltip" data-title="<?php echo e(_dt($d['dateadded'])); ?>"><?php echo e(time_ago($d['dateadded'])); ?></span></td>
          </tr>
        <?php } } else { ?>
          <tr><td colspan="8" class="text-center text-muted"><?php echo _l('no_results_found'); ?></td></tr>
        <?php } ?>
      </tbody>
    </table>
  </div>
</div>


