<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                            <h4 class="tw-m-0"><?php echo _l('deals_kanban'); ?></h4>
                            <div class="tw-flex tw-items-center tw-space-x-2">
                                <select id="pipeline-filter" class="selectpicker" data-width="200px">
                                    <?php foreach ($pipelines as $pipeline) { ?>
                                        <option value="<?php echo e($pipeline['id']); ?>" <?php echo $pipeline['id'] == ($this->input->get('pipeline_id') ?: $pipelines[0]['id']) ? 'selected' : ''; ?>>
                                            <?php echo html_entity_decode($pipeline['name']); ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <a href="<?php echo admin_url('deals'); ?>" class="btn btn-default"><i class="fa fa-list"></i>
                                    <?php echo _l('table_view'); ?></a>
                            </div>
                        </div>
                        <hr class="hr-panel-heading" />
                        <div class="kanban-wrapper">
                            <div class="row" id="kanban-columns">
                                <?php foreach ($stages as $stage) { ?>
                                  <?php //dd($stage); ?>
                                    <ul class="kan-ban-col" data-col-stage-id="<?php echo e($stage['id']); ?>"
                                        data-total-pages="<?php echo e($stage['total_pages']); ?>"
                                        data-total="<?php echo e($stage['total_deals']); ?>">
                                        <li class="kan-ban-col-wrapper">
                                            <div class="panel-heading tw-bg-neutral-700 tw-text-white">
                                                <span class="heading"><?php echo html_entity_decode($stage['name']); ?></span>
                                                <span class="tw-ml-1">(<span class="total-deals"><?php echo e($stage['total_deals']); ?></span>)</span>
                                            </div>
                                            <div class="kan-ban-content-wrapper">
                                                <div class="kan-ban-content">
                                                    <ul class="deals-stage sortable" data-stage-id="<?php echo e($stage['id']); ?>" style="gap: 4px; display: flex; flex-direction: column;">
                                                        <?php foreach ($stage['deals'] as $deal) { ?>
                                                            <li style="margin-bottom: 4px; list-style: none; padding: 0; border: none; background: none;">
                                                                <?php $this->load->view('deals/_kan_ban_card', ['deal' => $deal, 'base_currency' => $base_currency]); ?>
                                                            </li>
                                                        <?php } ?>
                                                        <?php if ($stage['total_deals'] > 0) { ?>
                                                            <li class="text-center not-sortable kanban-load-more"
                                                                data-load-stage="<?php echo e($stage['id']); ?>"
                                                                style="margin-bottom: 16px;">
                                                                <a href="#"
                                                                    class="btn btn-default btn-block<?php if ($stage['total_pages'] <= 1) { echo ' disabled'; } ?>"
                                                                    data-page="<?php echo e($stage['total_pages']); ?>"
                                                                    onclick="kanban_load_more(<?php echo e($stage['id']); ?>, this, 'deals/kanban_load_more', 315, 360); return false;">
                                                                    <?php echo _l('load_more'); ?>
                                                                </a>
                                                            </li>
                                                        <?php } ?>
                                                        <li class="text-center not-sortable mtop30 kanban-empty<?php if ($stage['total_deals'] > 0) { echo ' hide'; } ?>" style="margin-bottom: 16px;">
                                                            <h4>
                                                                <i class="fa-solid fa-circle-notch" aria-hidden="true"></i><br /><br />
                                                                <?php echo _l('no_deals_found'); ?>
                                                            </h4>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script src="<?php echo module_dir_url('deals', 'assets/js/deals_kanban.js'); ?>"></script>
<script>
    $(function () {
        $('.selectpicker').selectpicker();

        $('.deals-stage.sortable').sortable({
            items: 'li:not(.not-sortable)',
            connectWith: '.deals-stage.sortable',
            helper: function (e, li) {
                return $(li).clone().addClass('kanban-drag');
            },
            update: function (event, ui) {
                if (this === ui.item.parent()[0]) {
                    var deal_id = ui.item.data('deal-id');
                    var stage_id = $(this).data('stage-id');
                    var pipeline_id = $('#pipeline-filter').val();
                    $.post(admin_url + 'deals/update_stage', {
                        deal_id: deal_id,
                        stage_id: stage_id,
                        pipeline_id: pipeline_id
                    }).done(function (response) {
                        response = JSON.parse(response);
                        if (!response.success) {
                            alert_float('danger', response.message || '<?php echo _l('error_updating_stage'); ?>');
                        }
                        updateKanbanTotals();
                    });
                }
            }
        });

        $('#pipeline-filter').on('change', function () {
            var pipeline_id = $(this).val();
            $.get(admin_url + 'deals/kanban?pipeline_id=' + pipeline_id, function (response) {
                $('#kanban-columns').html($(response).find('#kanban-columns').html());
                $('.selectpicker').selectpicker('refresh');
                $('.deals-stage.sortable').sortable('refresh');
                updateKanbanTotals();
            });
        });

        function updateKanbanTotals() {
            $('.kan-ban-col').each(function () {
                var total = $(this).find('li.deal-kan-ban').length;
                $(this).find('.total-deals').text(total);
                $(this).find('.kanban-empty').toggleClass('hide', total > 0);
            });
        }
    });
</script>