
<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
<div class="content">
  <div class="row">
    <div class="col-md-12">
      <div class="tw-mb-2">
        <a href="#" onclick="new_pipeline();return false;" class="btn btn-primary">
          <i class="fa fa-plus"></i> <?= _l('new_pipeline'); ?>
        </a>
      </div>

      <div class="panel_s">
        <div class="panel-body">
          <?php if (count($pipelines)>0) { ?>
            <table class="table dt-table" data-order-col="0" data-order-type="asc">
              <thead>
                <tr>
                  <th><?= _l('id'); ?></th>
                  <th><?= _l('pipeline_name'); ?></th>
                  <th><?= _l('options'); ?></th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($pipelines as $p) { ?>
                <tr>
                  <td><?= (int)$p['id']; ?></td>
                  <td><?= e($p['name']); ?></td>
                  <td>
                    <a href="#" class="btn btn-sm btn-default" onclick="edit_pipeline(this, <?= (int)$p['id']; ?>);return false;"
                       data-name="<?= e($p['name']); ?>"
                       data-default="<?= (int)$p['is_default']; ?>">
                       <i class="fa fa-pencil"></i>
                    </a>
                    <a href="<?= admin_url('deals/delete_pipeline/' . (int)$p['id']); ?>" class="btn btn-sm btn-danger _delete">
                      <i class="fa fa-remove"></i>
                    </a>
                  </td>
                </tr>
                <tr>
                  <td colspan="3">
                    <div class="well">
                      <div class="tw-flex tw-items-center tw-justify-between">
                        <h5 class="tw-font-medium"><?= _l('deal_stage'); ?></h5>
                        <a href="#" class="btn btn-sm btn-primary" onclick="new_stage(<?= (int)$p['id']; ?>);return false;"><?= _l('new_stage'); ?></a>
                      </div>
                      <ul class="list-unstyled" id="pipeline-stages-<?= (int)$p['id']; ?>">
                        <?php if(isset($p['stages'])) { foreach ($p['stages'] as $s) { ?>
                          <li class="tw-py-1" data-stage-id="<?= (int)$s['id']; ?>">
                            <span class="label" style="background:<?= e($s['color']); ?>"><?= e($s['name']); ?></span>
                            <small>(<?= _l('stage_order'); ?>: <?= (int)$s['stage_order']; ?>, <?= _l('stage_win_probability'); ?>: <?= (int)$s['win_probability']; ?>%)</small>
                            <div class="pull-right">
                              <a href="#" class="btn btn-xs btn-default" onclick="edit_stage(this, <?= (int)$s['id']; ?>);"
                                 data-name="<?= e($s['name']); ?>" data-color="<?= e($s['color']); ?>"
                                 data-prob="<?= (int)$s['win_probability']; ?>" data-order="<?= (int)$s['stage_order']; ?>"
                                 data-won="<?= (int)$s['is_won']; ?>" data-lost="<?= (int)$s['is_lost']; ?>">
                                <i class="fa fa-pencil"></i>
                              </a>
                              <a href="<?= admin_url('deals/delete_stage/' . (int)$s['id']); ?>" class="btn btn-xs btn-danger _delete">
                                <i class="fa fa-remove"></i>
                              </a>
                            </div>
                          </li>
                        <?php } } ?>
                      </ul>
                    </div>
                  </td>
                </tr>
                <?php } ?>
              </tbody>
            </table>
          <?php } else { ?>
            <p class="text-muted"><?= _l('not_available'); ?></p>
          <?php } ?>
        </div>
      </div>
    </div>

  </div>
</div>
</div>

<?php $this->load->view('deals/modal'); ?>
<?php init_tail(); ?>

<script>
function new_pipeline(){
  $('#pipeline_modal').modal('show');
  $('.edit-title').addClass('hide');
  $('#pipeline-form').trigger('reset');
  $('#pipeline-additional').html('');
}
function edit_pipeline(invoker, id){
  $('#pipeline_modal').modal('show');
  $('.add-title').addClass('hide');
  $('#pipeline-additional').html('<input type="hidden" name="id" value="'+id+'">');
  $('#pipeline-form input[name="name"]').val($(invoker).data('name'));
  $('#pipeline-form input[name="is_default"]').prop('checked', $(invoker).data('default')==1);
}
function new_stage(pipeline_id){
  $('#stage_modal').modal('show');
  $('.edit-title').addClass('hide');
  $('#stage-form').trigger('reset');
  $('#stage-additional').html('<input type="hidden" name="pipeline_id" value="'+pipeline_id+'">');
}
function edit_stage(invoker, id){
  $('#stage_modal').modal('show');
  $('.add-title').addClass('hide');
  $('#stage-additional').html('<input type="hidden" name="id" value="'+id+'">');
  $('#stage-form input[name="name"]').val($(invoker).data('name'));
  $('#stage-form .colorpicker-input').colorpicker('setValue', $(invoker).data('color'));
  $('#stage-form input[name="win_probability"]').val($(invoker).data('prob'));
  $('#stage-form input[name="stage_order"]').val($(invoker).data('order'));
  $('#stage-form input[name="is_won"]').prop('checked', $(invoker).data('won')==1);
  $('#stage-form input[name="is_lost"]').prop('checked', $(invoker).data('lost')==1);
}
$(function(){
  appValidateForm($('#pipeline-form'), {name:'required'});
  appValidateForm($('#stage-form'), {name:'required', pipeline_id:'required'});
});
</script>
