<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
if (!isset($sources)) {
    $CI = &get_instance();
    $CI->load->model('deals/deals_model');
    $sources = $CI->deals_model->get_source();
}
$csrf_name = $CI->security->get_csrf_token_name();
$csrf_hash = $CI->security->get_csrf_hash();
?>
<!-- <?php //init_head(); ?> -->
<div class="panel_s">
    <div class="panel-body">
        <div class="">
            <div class="row">
                <div class="col-md-12">
                    <div class="tw-mb-2">
                        <a href="#" onclick="new_source(); return false;" class="btn btn-primary">
                            <i class="fa-regular fa-plus tw-mr-1"></i>
                            <?= _l('deal_new_source'); ?>
                        </a>
                    </div>
                    <div class="panel_s">
                        <div class="panel-body panel-table-full">
                            <?php if (count($sources) > 0) { ?>
                                <table class="table dt-table" data-order-col="1" data-order-type="asc">
                                    <thead>
                                        <th><?= _l('id'); ?></th>
                                        <th><?= _l('deals_sources_table_name'); ?></th>
                                        <th><?= _l('options'); ?></th>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($sources as $source) { ?>
                                            <tr>
                                                <td><?= e($source['id']); ?></td>
                                                <td>
                                                    <a href="#" class="tw-font-medium"
                                                        onclick="edit_source(this,<?= e($source['id']); ?>); return false;"
                                                        data-name="<?= html_escape($source['name']); ?>">
                                                        <?= html_entity_decode($source['name']); ?>
                                                    </a>
                                                    <br>
                                                    <span class="text-muted">
                                                        <?= _l('deals_table_total', total_rows(db_prefix() . 'deals', ['source' => $source['id']])); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="tw-flex tw-items-center tw-space-x-2">
                                                        <a href="#"
                                                            onclick="edit_source(this,<?= e($source['id']); ?>); return false;"
                                                            data-name="<?= html_escape($source['name']); ?>"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                            <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                        </a>
                                                        <a href="#"
                                                            onclick="delete_source(<?= e($source['id']); ?>); return false;"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                            <i class="fa-regular fa-trash-can fa-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            <?php } else { ?>
                                <p class="no-margin">
                                    <?= _l('deals_sources_not_found'); ?>
                                </p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="source_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit_source'); ?></span>
                    <span class="add-title"><?= _l('deal_new_source'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <div class="form-group">
                            <label for="name" class="control-label"><?= _l('deals_source_add_edit_name'); ?></label>
                            <input type="text" id="name" name="name" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" onclick="manage_deals_sources()"><?= _l('submit'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
    var CSRF = { name: '<?= $csrf_name; ?>', value: '<?= $csrf_hash; ?>' };

    function getSourceApiUrl() {
        return (typeof admin_url !== 'undefined' ? admin_url : '<?= admin_url(); ?>') + 'deals/source';
    }

    function requestSource(action, payload, callback) {
        var form = new FormData();
        form.append('action', action);
        Object.keys(payload || {}).forEach(function (k) {
            if (Array.isArray(payload[k])) {
                payload[k].forEach(function(item, idx) {
                    form.append(k + '[]', item);
                });
            } else {
                form.append(k, payload[k]);
            }
        });
        form.append(CSRF.name, CSRF.value);
        fetch(getSourceApiUrl(), {
            method: 'POST',
            body: form,
            credentials: 'same-origin'
        })
        .then(function(r) {
            return r.json().catch(function() { return {}; });
        })
        .then(function(data) {
            if (typeof callback === 'function') {
                callback(data.success, data);
            } else {
                if (data.success) {
                    $('#source_modal').modal('hide');
                    location.reload();
                } else {
                    alert('Operation failed');
                }
            }
        });
    }

    function manage_deals_sources() {
        var nameInput = document.getElementById('name');
        var idInput = document.querySelector('#additional input[name="id"]');
        var payload = {};

        if (!nameInput || !nameInput.value.trim()) {
            alert('Name is required.');
            return false;
        }

        payload.name = nameInput.value.trim();
        if (idInput && idInput.value) {
            payload.id = idInput.value;
            payload.action = 'update';
        } else {
            payload.action = 'create';
        }

        requestSource(payload.action, payload, function(success) {
            if (success) {
                $('#source_modal').modal('hide');
                // Prevent resubmission by using a small delay before reload
                setTimeout(function() {
                    window.location.href = window.location.href;
                }, 100);
            } else {
                alert('Operation failed');
            }
        });
        return false;
    }

    function new_source() {
        $('#source_modal').modal('show');
        $('.edit-title').addClass('hide');
        $('.add-title').removeClass('hide');
        $('#additional').html('');
        $('#name').val('');
    }

    function edit_source(invoker, id) {
        $('#additional').html('<input type="hidden" name="id" value="' + id + '">');
        $('#name').val($(invoker).data('name'));
        $('#source_modal').modal('show');
        $('.add-title').addClass('hide');
        $('.edit-title').removeClass('hide');
    }

    function delete_source(id) {
        if (confirm('<?= _l('confirm_action_prompt'); ?>')) {
            requestSource('delete', { id: id });
        }
    }

    $(function () {
        $('#source_modal').on('hidden.bs.modal', function () {
            $('#additional').html('');
            $('#name').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });

        $('#name').on('input', function() {
            if ($(this).val().trim() === '') {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
    });
</script>
<?php //init_tail(); ?>