<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
$CI = &get_instance();
if (!isset($statuses)) {
    $CI->load->model('deals/deals_model');
    $statuses = $CI->deals_model->get_statuses();
}
$csrf_name = $CI->security->get_csrf_token_name();
$csrf_hash = $CI->security->get_csrf_hash();
?>
<div class="panel_s">
    <div class="panel-body">
        <div class="">
            <div class="row">
                <div class="col-md-12">
                    <div class="tw-mb-2">
                        <a href="#" onclick="new_status(); return false;" class="btn btn-primary">
                            <i class="fa-regular fa-plus tw-mr-1"></i>
                            <?= _l('deal_new_status'); ?>
                        </a>
                    </div>
                    <div class="panel_s">
                        <div class="panel-body panel-table-full">
                            <?php if (count($statuses) > 0) { ?>
                                <table class="table dt-table" data-order-col="1" data-order-type="asc">
                                    <thead>
                                        <th><?= _l('id'); ?></th>
                                        <th><?= _l('deals_status_table_name'); ?></th>
                                        <th><?= _l('options'); ?></th>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($statuses as $status) { ?>
                                            <tr>
                                                <td><?= e($status['id']); ?></td>
                                                <td>
                                                    <a href="#" class="tw-font-medium"
                                                        onclick="edit_status(this,<?= e($status['id']); ?>); return false;"
                                                        data-name="<?= html_escape($status['name']); ?>"
                                                        data-color="<?= html_escape($status['color']); ?>"
                                                        data-order="<?= e($status['statusorder']); ?>">
                                                        <?= html_entity_decode($status['name']); ?>
                                                    </a><br />
                                                    <span class="text-muted">
                                                        <?= _l('deals_table_total', total_rows(db_prefix() . 'deals', ['status' => $status['id']])); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="tw-flex tw-items-center tw-space-x-2">
                                                        <a href="#"
                                                            onclick="edit_status(this,<?= e($status['id']); ?>); return false;"
                                                            data-name="<?= html_escape($status['name']); ?>"
                                                            data-color="<?= html_escape($status['color']); ?>"
                                                            data-order="<?= e($status['statusorder']); ?>"
                                                            class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700">
                                                            <i class="fa-regular fa-pen-to-square fa-lg"></i>
                                                        </a>
                                                        <?php if (empty($status['isdefault']) || $status['isdefault'] == 0) { ?>
                                                            <a href="#"
                                                                onclick="delete_status(<?= e($status['id']); ?>); return false;"
                                                                class="tw-text-neutral-500 hover:tw-text-neutral-700 focus:tw-text-neutral-700 _delete">
                                                                <i class="fa-regular fa-trash-can fa-lg"></i>
                                                            </a>
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            <?php } else { ?>
                                <p class="no-margin">
                                    <?= _l('deal_statuses_not_found'); ?>
                                </p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="status_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?= _l('edit'); ?></span>
                    <span class="add-title"><?= _l('deal_new_status'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional-status"></div>
                        <div class="form-group">
                            <label for="status_name" class="control-label"><?= _l('deals_status_table_name'); ?></label>
                            <input type="text" id="status_name" name="name" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="status_color" class="control-label"><?= _l('color'); ?></label>
                            <input type="color" id="status_color" name="color" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="status_order" class="control-label"><?= _l('order'); ?></label>
                            <input type="number" id="status_order" name="order" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="submit" class="btn btn-primary" onclick="manage_deals_statuses();return false;"><?= _l('submit'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
    var CSRF = { name: '<?= $csrf_name; ?>', value: '<?= $csrf_hash; ?>' };

    function getStatusApiUrl() {
        return (typeof admin_url !== 'undefined' ? admin_url : '<?= admin_url(); ?>') + 'deals/status';
    }

    function requestStatus(action, payload, callback) {
        var form = new FormData();
        form.append('action', action);
        if (payload && typeof payload === 'object') {
            Object.keys(payload).forEach(function (k) {
                // Only append if not 'action' (already appended above)
                if (k === 'action') return;
                if (Array.isArray(payload[k])) {
                    payload[k].forEach(function(item) {
                        form.append(k + '[]', item);
                    });
                } else if (payload[k] !== undefined && payload[k] !== null) {
                    form.append(k, payload[k]);
                }
            });
        }
        form.append(CSRF.name, CSRF.value);
        fetch(getStatusApiUrl(), {
            method: 'POST',
            body: form,
            credentials: 'same-origin'
        })
        .then(function(r) {
            return r.json().catch(function() { return {}; });
        })
        .then(function(data) {
            // Defensive: if data is a string, try to parse as JSON
            if (typeof data === 'string') {
                try {
                    data = JSON.parse(data);
                } catch (e) {
                    data = {};
                }
            }
            if (typeof callback === 'function') {
                callback(data.success, data);
            } else {
                if (data.success) {
                    $('#status_modal').modal('hide');
                } else {
                    alert('Operation failed');
                }
            }
        });
    }

    function manage_deals_statuses() {
        var nameInput = document.getElementById('status_name');
        var colorInput = document.getElementById('status_color');
        var orderInput = document.getElementById('status_order');
        var idInput = document.querySelector('#additional-status input[name="id"]');
        var payload = {};

        if (!nameInput || !nameInput.value.trim()) {
            alert('<?= _l('deals_status_table_name'); ?> is required.');
            return false;
        }

        payload.name = nameInput.value.trim();
        payload.color = colorInput && colorInput.value ? colorInput.value : '';
        payload.order = orderInput && orderInput.value ? orderInput.value : '';

        if (idInput && idInput.value) {
            payload.id = idInput.value;
            payload.action = 'update';
        } else {
            payload.action = 'create';
        }

        requestStatus(payload.action, payload, function(success) {
            if (success) {
                $('#status_modal').modal('hide');
                setTimeout(function() {
                    window.location.href = window.location.href;
                }, 100);
            } else {
                alert('Operation failed');
            }
        });
        return false;
    }

    function new_status() {
        $('#status_modal').modal('show');
        $('.edit-title').addClass('hide');
        $('.add-title').removeClass('hide');
        $('#additional-status').html('');
        $('#status_name').val('');
        $('#status_color').val('');
        $('#status_order').val('');
    }

    function edit_status(invoker, id) {
        $('#additional-status').html('<input type="hidden" name="id" value="' + id + '">');
        $('#status_name').val($(invoker).data('name'));
        $('#status_color').val($(invoker).data('color'));
        $('#status_order').val($(invoker).data('order'));
        $('#status_modal').modal('show');
        $('.add-title').addClass('hide');
        $('.edit-title').removeClass('hide');
    }

    function delete_status(id) {
        if (confirm('<?= _l('confirm_action_prompt'); ?>')) {
            requestStatus('delete', { id: id });
        }
    }

    $(function () {
        $('#status_modal').on('hidden.bs.modal', function () {
            $('#additional-status').html('');
            $('#status_name').val('');
            $('#status_color').val('');
            $('#status_order').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });

        $('#status_name').on('input', function() {
            if ($(this).val().trim() === '') {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
            }
        });
    });
</script>