
<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="modal fade" id="pipeline_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <?= form_open(admin_url('deals/pipeline'), ['id'=>'pipeline-form']); ?>
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">
          <span class="edit-title"><?= _l('edit_pipeline'); ?></span>
          <span class="add-title"><?= _l('new_pipeline'); ?></span>
        </h4>
      </div>
      <div class="modal-body">
        <div id="pipeline-additional"></div>
        <?= render_input('name', 'pipeline_name'); ?>
        <div class="checkbox checkbox-primary">
          <input type="checkbox" name="is_default" id="is_default">
          <label for="is_default"><?= _l('pipeline_is_default'); ?></label>
        </div>
        <?= render_select('visibility', [
            ['id'=>'company','name'=>'Company'],
            ['id'=>'teams','name'=>'Teams'],
            ['id'=>'users','name'=>'Users'],
        ], ['id','name'], 'pipeline_visibility', 'company'); ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
        <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
      </div>
    </div>
    <?= form_close(); ?>
    </div>
</div>

<div class="modal fade" id="stage_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <?= form_open(admin_url('deals/stage'), ['id'=>'stage-form']); ?>
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
        <h4 class="modal-title">
          <span class="edit-title"><?= _l('edit_stage'); ?></span>
          <span class="add-title"><?= _l('new_stage'); ?></span>
        </h4>
      </div>
      <div class="modal-body">
        <div id="stage-additional"></div>
        <?= render_input('name', 'stage_name'); ?>
        <?= render_color_picker('color', _l('stage_color')); ?>
        <?= render_input('win_probability', 'stage_win_probability', 100, 'number', ['min'=>0,'max'=>100]); ?>
        <?= render_input('stage_order', 'stage_order', '', 'number'); ?>
        <div class="checkbox checkbox-primary">
          <input type="checkbox" name="is_won" id="is_won">
          <label for="is_won"><?= _l('stage_is_won'); ?></label>
        </div>
        <div class="checkbox checkbox-primary">
          <input type="checkbox" name="is_lost" id="is_lost">
          <label for="is_lost"><?= _l('stage_is_lost'); ?></label>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
        <button type="submit" class="btn btn-primary"><?= _l('submit'); ?></button>
      </div>
    </div>
    <?= form_close(); ?>
    </div>
</div>