<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_attachment_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open_multipart(admin_url('deals/upload_attachment/' . $deal_id), ['id' => 'add_attachment_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('add_attachment'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="attachment" class="control-label"><?php echo _l('choose_file'); ?> <span class="text-danger">*</span></label>
                    <input type="file" name="attachment" id="attachment" class="form-control" required>
                    <small class="text-muted"><?php echo _l('allowed_files'); ?>: <?php echo get_option('allowed_files'); ?></small>
                </div>
                <div class="form-group">
                    <label for="description" class="control-label"><?php echo _l('description'); ?></label>
                    <textarea name="description" id="attachment_description" class="form-control" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <label for="external" class="control-label"><?php echo _l('external_link'); ?></label>
                    <input type="url" name="external" id="external_link" class="form-control" placeholder="https://example.com">
                    <small class="text-muted"><?php echo _l('external_link_help'); ?></small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_attachment_form'), {
        attachment: 'required'
    });
    
    $('#add_attachment_modal').on('hidden.bs.modal', function() {
        $('#add_attachment_form')[0].reset();
    });
    
    // File size validation
    $('#attachment').on('change', function() {
        var file = this.files[0];
        if (file) {
            var maxSize = <?php echo get_option('max_file_size') * 1024 * 1024; ?>; // Convert MB to bytes
            if (file.size > maxSize) {
                alert_float('danger', '<?php echo _l('file_too_large'); ?>');
                $(this).val('');
            }
        }
    });
});
</script>
