<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_email_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open_multipart(admin_url('deals/add_deal_email/' . $deal_id), ['id' => 'add_email_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('send_email'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="recipient_select"><?php echo _l('to_email'); ?> <span class="text-danger">*</span></label>
                    <select id="recipient_select" class="form-control">
                        <option value="" selected disabled><?php echo _l('select'); ?></option>
                        <option value="__custom__"><?php echo _l('custom'); ?></option>
                    </select>
                </div>
                <div class="form-group" id="custom_email_group" style="display:none;">
                    <label for="to_email"><?php echo _l('enter_email'); ?></label>
                    <input type="email" name="to_email" id="to_email" class="form-control" placeholder="name@example.com">
                </div>
                <!-- New hidden field for username -->
                <input type="hidden" name="to_username" id="to_username">

                <div class="form-group">
                    <label for="template_select"><?php echo _l('email_templates'); ?> <span class="text-danger">*</span></label>
                    <select name="template_id" id="template_select" class="form-control" required>
                        <option value="" selected disabled><?php echo _l('select'); ?></option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="email_attachments"><?php echo _l('attachments'); ?></label>
                    <input type="file" name="attachments[]" id="email_attachments" multiple class="form-control">
                </div>

                <input type="hidden" name="subject" id="email_subject">
                <textarea name="message" id="email_message" class="hide"></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('send'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    var dealId = <?php echo json_encode($deal_id); ?>;
    var $recipientSelect = $('#recipient_select');
    var $templateSelect = $('#template_select');
    var $customEmailGroup = $('#custom_email_group');
    var $toEmail = $('#to_email');
    var $toUsername = $('#to_username');

    // Store email->username mapping
    var emailToUsernameMap = {};

    // Load deal contacts via AJAX
    $.ajax({
        url: admin_url + 'deals/get_deal_contacts/' + dealId,
        type: 'GET',
        dataType: 'json',
        success: function(res) {
            if (Array.isArray(res)) {
                res.forEach(function(contact) {
                    if (contact.email) {
                        var label = (contact.firstname ? contact.firstname : '') + 
                                    (contact.lastname ? ' ' + contact.lastname : '') + 
                                    (contact.email ? ' <' + contact.email + '>' : '');
                        $recipientSelect.append($('<option>', { value: contact.email, text: label }));
                        // Save username for this email
                        var username = (contact.firstname ? contact.firstname : '') + (contact.lastname ? ' ' + contact.lastname : '');
                        emailToUsernameMap[contact.email] = $.trim(username);
                    }
                });
            }
        }
    });

    // Optionally, also load companies as recipients (if needed)
    $.ajax({
        url: admin_url + 'deals/get_deal_email_recipients/' + dealId,
        type: 'GET',
        dataType: 'json',
        success: function(res) {
            if (res && res.success && Array.isArray(res.recipients)) {
                res.recipients.forEach(function(r){
                    // Avoid duplicate emails (if already added from contacts)
                    if ($recipientSelect.find('option[value="' + r.email + '"]').length === 0) {
                        $recipientSelect.append($('<option>', { value: r.email, text: r.label }));
                        // Try to extract username from label (before <email>)
                        var username = '';
                        if (r.label) {
                            var match = r.label.match(/^(.*?)\s*<.*?>$/);
                            if (match && match[1]) {
                                username = $.trim(match[1]);
                            }
                        }
                        emailToUsernameMap[r.email] = username;
                    }
                });
            }
        }
    });

    // Load active templates (from deals_templates)
    $.get(admin_url + 'deals/get_deal_email_templates', function(res){
        if (res && res.success && Array.isArray(res.templates)) {
            res.templates.forEach(function(t){
                $templateSelect.append($('<option>', { value: t.emailtemplateid, text: t.name }));
            });
        }
    }, 'json');

    // Toggle custom email field and set username
    $recipientSelect.on('change', function(){
        var val = $(this).val();
        if (val === '__custom__') {
            $customEmailGroup.show();
            $toEmail.prop('required', true).val('');
            $toUsername.val('');
        } else {
            $customEmailGroup.hide();
            $toEmail.prop('required', false).val(val || '');
            // Set username if available
            if (val && emailToUsernameMap[val]) {
                $toUsername.val(emailToUsernameMap[val]);
            } else {
                $toUsername.val('');
            }
        }
    });

    // If user types a custom email, clear username
    $toEmail.on('input', function() {
        $toUsername.val('');
    });

    // Basic validation
    appValidateForm($('#add_email_form'), {
        template_id: 'required',
        to_email: {
            required: function(){
                return $('#recipient_select').val() === '__custom__' || !$('#recipient_select').val();
            },
            email: true
        }
    });

    $('#add_email_modal').on('hidden.bs.modal', function() {
        $('#add_email_form')[0].reset();
        $customEmailGroup.hide();
        $toEmail.prop('required', false).val('');
        $recipientSelect.val('');
        $templateSelect.val('');
        $toUsername.val('');
    });
});
</script>