<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_note_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <?php echo form_open(admin_url('deals/add_deal_note/' . $deal_id), ['id' => 'add_note_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('add_note'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="description" class="control-label"><?php echo _l('note_description'); ?> <span class="text-danger">*</span></label>
                    <textarea name="description" id="description" class="form-control" rows="4" required></textarea>
                </div>
                <div class="form-group">
                    <label for="date_contacted" class="control-label"><?php echo _l('date_contacted'); ?></label>
                    <div class="input-group">
                        <input type="text" name="date_contacted" id="date_contacted" class="form-control datepicker" value="<?php echo date('Y-m-d'); ?>">
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label"><?php echo _l('contact_status'); ?></label>
                    <div class="radio radio-primary">
                        <input type="radio" name="contacted_indicator" id="contacted_yes" value="yes" checked>
                        <label for="contacted_yes"><?php echo _l('i_got_in_touch_with_this_lead'); ?></label>
                    </div>
                    <div class="radio radio-primary">
                        <input type="radio" name="contacted_indicator" id="contacted_no" value="no">
                        <label for="contacted_no"><?php echo _l('i_have_not_contacted_this_lead'); ?></label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('add_note'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_note_form'), {
        description: 'required'
    });
    
    $('#add_note_modal').on('hidden.bs.modal', function() {
        $('#add_note_form')[0].reset();
        $('#date_contacted').val('<?php echo date('Y-m-d'); ?>');
        $('#contacted_yes').prop('checked', true);
    });
    
    // Initialize datepicker
    if (typeof($.fn.datepicker) !== 'undefined') {
        $('#date_contacted').datepicker({
            dateFormat: 'yy-mm-dd'
        });
    }
});
</script>
