<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="add_task_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <?php echo form_open(admin_url('deals/add_task/' . $deal_id), ['id' => 'add_task_form']); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><?php echo _l('add_new_task'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="checkbox checkbox-primary">
                            <input type="checkbox" name="public" id="public">
                            <label for="public"><?php echo _l('public'); ?></label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="checkbox checkbox-primary">
                            <input type="checkbox" name="billable" id="billable" checked>
                            <label for="billable"><?php echo _l('billable'); ?></label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <a href="#" class="pull-right"><?php echo _l('attach_files'); ?></a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php echo render_input('name', 'task_add_edit_subject', '', 'text', ['required' => true]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo render_input('hourly_rate', 'task_hourly_rate', '0', 'number'); ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo render_date_input('startdate', 'task_start_date', date('Y-m-d'), ['required' => true]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo render_date_input('duedate', 'task_duedate'); ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo render_select('priority', $priorities, ['id', 'name'], 'task_priority', 2); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo render_select('repeat_every', $repeat_every, ['id', 'name'], 'task_repeat_every'); ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo render_select('rel_type', [['id' => 'deal', 'name' => _l('deal')]], ['id', 'name'], 'related_to', 'deal', ['disabled' => true]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo render_select('rel_id', [['id' => $deal_id, 'name' => $deal_name]], ['id', 'name'], 'deal', $deal_id, ['disabled' => true]); ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo render_select('assignees[]', $staff, ['staffid', ['firstname', 'lastname']], 'task_assignees', get_staff_user_id(), ['multiple' => true]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php echo render_select('followers[]', $staff, ['staffid', ['firstname', 'lastname']], 'task_followers', '', ['multiple' => true]); ?>
                    </div>
                    <div class="col-md-6">
                        <?php echo render_input('tags', 'tags'); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php echo render_textarea('description', 'task_add_edit_description', '', ['rows' => 4, 'placeholder' => _l('add_description')]); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function() {
    appValidateForm($('#add_task_form'), {
        name: 'required',
        startdate: 'required'
    });
    
    $('#add_task_modal').on('hidden.bs.modal', function() {
        $('#add_task_form')[0].reset();
        $('#add_task_form .selectpicker').selectpicker('refresh');
    });
});
</script>
