<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php
$CI = &get_instance();
if (!isset($pipelines)) {
    $CI->load->model('deals/deals_model');
    $pipelines = $CI->deals_model->get_pipelines();
}
if (is_array($pipelines)) {
    foreach ($pipelines as $idx => $p) {
        if (!isset($p['stages'])) {
            $pipelines[$idx]['stages'] = $CI->deals_model->get_stages($p['id']);
        }
        foreach ($pipelines[$idx]['stages'] as $sidx => $s) {
            $pipelines[$idx]['stages'][$sidx]['statuses'] = $CI->deals_model->get_stage_statuses($s['id']);
        }
    }
}
$selectedPipelineId = isset($pipelines[0]['id']) ? (int)$pipelines[0]['id'] : 0;
?>

<h4 class="tw-mb-4"><?php echo _l('pipelines'); ?></h4>

<div class="panel_s">
  <div class="panel-body">
    <div class="row">
      <div class="col-md-12">
        <h5><?php echo _l('deals'); ?> <?php echo _l('pipelines'); ?></h5>
        
        <!-- Pipeline Management Section -->
        <div class="form-group">
          <label class="control-label"><?php echo _l('pipelines'); ?></label>
          <select id="pipeline_select" class="selectpicker" data-width="100%" onchange="onPipelineChange()">
            <option value=""><?php echo _l('select_pipeline'); ?></option>
            <?php foreach (($pipelines ?? []) as $p) { ?>
              <option value="<?php echo (int)$p['id']; ?>" <?php echo ((int)$p['id']===$selectedPipelineId?'selected':''); ?> data-name="<?php echo html_escape($p['name']); ?>"><?php echo html_entity_decode($p['name']); ?></option>
            <?php } ?>
          </select>
        </div>
        
        <!-- Add/Edit Pipeline Form -->
        <div class="form-group">
          <div class="input-group">
            <input type="text" id="pipeline_name" class="form-control" placeholder="<?php echo _l('pipeline_name'); ?>">
            <span class="input-group-btn">
              <button id="pipeline_action_btn" class="btn btn-primary" type="button" onclick="createOrUpdatePipeline()"><?php echo _l('add'); ?></button>
            </span>
          </div>
        </div>
        
        <!-- Pipeline List -->
        <ul class="list-group" id="pipelines-list" style="max-height:60vh; overflow:auto;">
          <?php foreach (($pipelines ?? []) as $p) { ?>
            <li class="list-group-item pipeline-item" data-id="<?php echo (int)$p['id']; ?>" style="<?php echo ((int)$p['id']!==$selectedPipelineId?'display:none;':''); ?>">
              <div class="tw-flex tw-justify-between tw-items-center">
                <strong><?php echo html_entity_decode($p['name']); ?></strong>
                <div>
                  <button class="btn btn-xs btn-default" onclick="editPipeline(<?php echo (int)$p['id']; ?>)"><i class="fa fa-pencil"></i></button>
                  <button class="btn btn-xs btn-danger" onclick="deletePipeline(<?php echo (int)$p['id']; ?>)"><i class="fa fa-trash"></i></button>
                </div>
              </div>
              
              <!-- Stages Section -->
              <div class="tw-mt-2">
                <small><?php echo _l('stages'); ?></small>
                <ul class="list-unstyled sortable-stages" data-pipeline="<?php echo (int)$p['id']; ?>">
                  <?php foreach (($p['stages'] ?? []) as $s) { ?>
                    <li class="stage-item tw-py-2 tw-flex tw-items-center tw-justify-between" data-id="<?php echo (int)$s['id']; ?>">
                      <div class="tw-flex tw-items-center tw-gap-2">
                        <i class="fa fa-grip-vertical text-muted handle" style="cursor: move;"></i>
                        <input class="form-control input-sm" style="width:260px" value="<?php echo html_entity_decode($s['name']); ?>" onchange="updateStage(<?php echo (int)$s['id']; ?>,{name:this.value})">
                      </div>
                      <div class="tw-flex tw-items-center tw-gap-2">
                        <div class="tw-flex tw-items-center" style="width:260px">
                          <input type="range" min="0" max="100" value="<?php echo (int)($s['win_probability'] ?? 100); ?>" class="form-control" oninput="document.getElementById('prob_<?php echo (int)$s['id']; ?>').innerText=this.value;" onchange="updateStage(<?php echo (int)$s['id']; ?>,{win_probability:this.value})">
                          <span id="prob_<?php echo (int)$s['id']; ?>" class="tw-ml-2"><?php echo (int)($s['win_probability'] ?? 100); ?></span>
                        </div>
                        <button class="btn btn-xs btn-default" type="button" onclick="openStageStatusesModal(<?php echo (int)$s['id']; ?>, '<?php echo html_entity_decode($s['name']); ?>'); return false;"><i class="fa fa-list"></i></button>
                        <button class="btn btn-xs btn-danger" onclick="deleteStage(<?php echo (int)$s['id']; ?>)"><i class="fa fa-trash"></i></button>
                      </div>
                    </li>
                  <?php } ?>
                </ul>
                <button class="btn btn-xs btn-success" onclick="addStage(<?php echo (int)$p['id']; ?>)"><i class="fa fa-plus"></i> <?php echo _l('add'); ?> <?php echo _l('stage'); ?></button>
              </div>
            </li>
          <?php } ?>
        </ul>
      </div>
    </div>
  </div>
</div>

<!-- Stage Statuses Modal -->
<div class="modal fade" id="stageStatusesModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title"><?php echo _l('stage_statuses'); ?> <span id="stageStatusesModalTitle"></span></h4>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <div class="input-group">
            <input type="text" id="stage_status_name" class="form-control" placeholder="<?php echo _l('stage_status_name'); ?>">
            <span class="input-group-btn">
              <button class="btn btn-primary" type="button" onclick="addStageStatusFromModal()"><?php echo _l('add'); ?></button>
            </span>
          </div>
        </div>
        <ul class="list-unstyled sortable-stage-statuses" id="stage-statuses-list">
          <!-- Statuses will be populated dynamically -->
        </ul>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
      </div>
    </div>
  </div>
</div>

<!-- Include jQuery UI for drag and drop -->
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

<style>
.sortable-stages, .sortable-stage-statuses {
    min-height: 20px;
}

.stage-item, .stage-status-item {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    margin-bottom: 5px;
    padding: 8px 12px;
    transition: all 0.2s ease;
}

.stage-item:hover, .stage-status-item:hover {
    background: #e9ecef;
    border-color: #adb5bd;
}

.stage-item.ui-sortable-helper, .stage-status-item.ui-sortable-helper {
    background: #fff;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    transform: rotate(2deg);
}

.stage-item.ui-sortable-placeholder, .stage-status-item.ui-sortable-placeholder {
    background: #f8f9fa;
    border: 2px dashed #dee2e6;
    visibility: visible !important;
    height: 40px;
}

.handle {
    cursor: move;
    color: #6c757d;
}

.handle:hover {
    color: #495057;
}

.pipeline-item {
    margin-bottom: 20px;
    border: 1px solid #dee2e6;
    border-radius: 6px;
}

.pipeline-item .list-group-item {
    border: none;
    border-radius: 6px;
}

.form-group {
    margin-bottom: 20px;
}

.btn-xs {
    padding: 2px 8px;
    font-size: 12px;
}
</style>

<script>
var CSRF = { name: '<?php echo $this->security->get_csrf_token_name(); ?>', value: '<?php echo $this->security->get_csrf_hash(); ?>' };
var pipelineStages = <?php echo json_encode($pipelines ?? []); ?>;
var currentStageId = null;

function createOrUpdatePipeline(){
  var select = document.getElementById('pipeline_select');
  var id = select.value;
  var name = document.getElementById('pipeline_name').value.trim();
  if (!name) { 
    alert('<?php echo _l('pipeline_name_required'); ?>');
    return; 
  }
  
  if (id) { 
    request('update', {id:id, name:name}); 
  } else { 
    request('create', {name:name}); 
  }
}

function onPipelineChange(){
  var select = document.getElementById('pipeline_select');
  var id = select.value;
  var name = select.options[select.selectedIndex] ? select.options[select.selectedIndex].getAttribute('data-name') : '';
  
  document.getElementById('pipeline_name').value = name || '';
  document.getElementById('pipeline_action_btn').innerText = name ? '<?php echo _l('edit'); ?>' : '<?php echo _l('add'); ?>';
  
  Array.prototype.forEach.call(document.querySelectorAll('.pipeline-item'), function(el){
    el.style.display = (String(el.getAttribute('data-id')) === String(id)) ? '' : 'none';
  });
}

function editPipeline(id){
  var name = prompt('<?php echo _l('enter_pipeline_name'); ?>');
  if(name && name.trim()){ 
    request('update', {id:id, name:name.trim()}); 
  }
}

function deletePipeline(id){
  if(confirm('<?php echo _l('delete_pipeline_confirm'); ?>')){ 
    request('delete', {id:id}); 
  }
}

function addStage(pipeline_id){
  var name = prompt('<?php echo _l('enter_stage_name'); ?>');
  if(name && name.trim()){ 
    request('create_stage', {pipeline_id:pipeline_id, name:name.trim()}); 
  }
}

function updateStage(id, payload){
  payload = payload || {};
  payload.id = id;
  payload.action = 'update_stage';
  var form = new FormData();
  Object.keys(payload).forEach(function(k){ form.append(k, payload[k]); });
  form.append(CSRF.name, CSRF.value);
  fetch('<?php echo admin_url('deals/pipelines'); ?>', { method:'POST', body: form, credentials: 'same-origin' })
    .then(r=>r.json()).then(data => {
      if (data.success) {
        location.reload();
      } else {
        alert('Failed to update stage');
      }
    });
}

function deleteStage(id){
  if(confirm('<?php echo _l('delete_stage_confirm'); ?>')){ 
    request('delete_stage', {id:id}); 
  }
}

function openStageStatusesModal(stageId, stageName) {
  currentStageId = stageId;
  document.getElementById('stageStatusesModalTitle').innerText = stageName;
  var stage = pipelineStages.flatMap(p => p.stages).find(s => s.id == stageId);
  var statuses = stage ? stage.statuses || [] : [];
  
  var list = document.getElementById('stage-statuses-list');
  list.innerHTML = '';
  statuses.forEach(function(status) {
    var li = document.createElement('li');
    li.className = 'stage-status-item tw-py-2 tw-flex tw-items-center tw-justify-between';
    li.setAttribute('data-id', status.id);
    li.innerHTML = `
      <div class="tw-flex tw-items-center tw-gap-2">
        <i class="fa fa-grip-vertical text-muted handle" style="cursor: move;"></i>
        <input class="form-control input-sm" style="width:260px" value="${status.name}" onchange="updateStageStatus(${status.id}, this.value)">
      </div>
      <div>
        <button class="btn btn-xs btn-danger" onclick="deleteStageStatus(${status.id})"><i class="fa fa-trash"></i></button>
      </div>
    `;
    list.appendChild(li);
  });

  $('#stageStatusesModal').modal('show');

  // Destroy previous sortable to avoid duplicate event bindings
  if ($('#stage-statuses-list').data('ui-sortable')) {
    $('#stage-statuses-list').sortable('destroy');
  }

  $('#stage-statuses-list').sortable({
    handle: '.handle',
    axis: 'y',
    cursor: 'move',
    opacity: 0.8,
    update: function(event, ui) {
      var order = $(this).children('li').map(function(){ 
        return $(this).data('id'); 
      }).get();
      // Instead of reloading, update the order in JS and show a toast or similar
      request('reorder_stage_statuses', { stage_id: currentStageId, order: order }, function(success) {
        if (!success) {
          alert('Failed to reorder statuses');
        }
      });
    }
  });
}

function addStageStatusFromModal() {
  var name = document.getElementById('stage_status_name').value.trim();
  if (!name) {
    alert('<?php echo _l('stage_status_name_required'); ?>');
    return;
  }
  if (!currentStageId) {
    alert('No stage selected');
    return;
  }
  //request('create_stage_status', { stage_id: currentStageId, name: name });
  request('create_stage_status', { stage_id: currentStageId, name: name }, function(success, data){
    if (success) {
      location.reload();
    } else {
      alert('Failed to add stage status');
    }
  });
}

function updateStageStatus(id, name) {
  if (name && name.trim()) {
    request('update_stage_status', { id: id, name: name.trim() });
  }
}

function deleteStageStatus(id) {
  if (confirm('<?php echo _l('delete_stage_status_confirm'); ?>')) {
    request('delete_stage_status', { id: id });
  }
}

function request(action, payload) {
  var form = new FormData();
  form.append('action', action);
  Object.keys(payload || {}).forEach(function(k) {
    if (Array.isArray(payload[k])) {
      payload[k].forEach(function(item, index) {
        form.append(k + '[]', item);
      });
    } else {
      form.append(k, payload[k]);
    }
  });
  form.append(CSRF.name, CSRF.value);
  fetch('<?php echo admin_url('deals/pipelines'); ?>', { 
    method: 'POST', 
    body: form, 
    credentials: 'same-origin' 
  }).then(r => r.json()).then(data => {
    if (data.success) {
      location.reload();
    } else {
      alert('Operation failed');
    }
  });
}

// Initialize drag and drop functionality
$(document).ready(function() {
  $('.sortable-stages').sortable({
    handle: '.handle',
    axis: 'y',
    cursor: 'move',
    opacity: 0.8,
    update: function(event, ui) {
      var pipeline = $(this).data('pipeline');
      var order = $(this).children('li').map(function(){ 
        return $(this).data('id'); 
      }).get();
      
      request('reorder_stages', { pipeline_id: pipeline, order: order });
    }
  });
  
  onPipelineChange();
});
</script>