<?php
defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
        'tbl_deals.id',
        'tbl_deals.name',
        'tbl_deals.company',
        '(SELECT GROUP_CONCAT(CONCAT(tbl_deals_pipelines.name, " - ", tbl_deals_stages.name, IF(tbl_deals_pipeline_relations.score IS NOT NULL, CONCAT(" (", tbl_deals_pipeline_relations.score, ")"), "")) SEPARATOR "; ")
            FROM tbl_deals_pipeline_relations 
            JOIN tbl_deals_pipelines ON tbl_deals_pipelines.id = tbl_deals_pipeline_relations.pipeline_id 
            JOIN tbl_deals_stages ON tbl_deals_stages.id = tbl_deals_pipeline_relations.stage_id 
            WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id) as pipeline_relations',
    'tbl_deals.deal_value',
    'tbl_deals.assigned',
    'tbl_deals.status_final',
    'tbl_deals.dateadded'
];

$sIndexColumn = 'id';
$sTable = 'tbl_deals';
$join = [];
$where = [];

$filters = $this->input->post('filters');
if ($filters) {
    $filters = json_decode($filters, true);
    foreach ($filters as $filter) {
        if ($filter['type'] === 'pipeline') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                JOIN tbl_deals_pipelines ON tbl_deals_pipelines.id = tbl_deals_pipeline_relations.pipeline_id 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipelines.id = ' . $this->db->escape($filter['value']) . ')';
        } elseif ($filter['type'] === 'stage') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                JOIN tbl_deals_stages ON tbl_deals_stages.id = tbl_deals_pipeline_relations.stage_id 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_stages.id = ' . $this->db->escape($filter['value']) . '
                AND tbl_deals_pipeline_relations.pipeline_id = ' . $this->db->escape($filter['pipelineId']) . ')';
        } elseif ($filter['type'] === 'status') {
            $where[] = 'tbl_deals.status_final = ' . $this->db->escape($filter['value']);
        } elseif ($filter['type'] === 'business_category') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipeline_relations.business_category_id = ' . $this->db->escape($filter['value']) . ')';
        } elseif ($filter['type'] === 'source') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipeline_relations.source_id = ' . $this->db->escape($filter['value']) . ')';
        } elseif ($filter['type'] === 'rating') {
            $where[] = 'EXISTS (SELECT 1 FROM tbl_deals_pipeline_relations 
                WHERE tbl_deals_pipeline_relations.deal_id = tbl_deals.id 
                AND tbl_deals_pipeline_relations.rating_id = ' . $this->db->escape($filter['value']) . ')';
        }
    }
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'tbl_deals.id',
    'tbl_deals.name',
    'tbl_deals.company',
    'tbl_deals.deal_value',
    'tbl_deals.assigned',
    'tbl_deals.status_final',
    'tbl_deals.dateadded'
]);

$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    $row[] = '<input type="checkbox" class="individual" data-to-table="deals" value="' . $aRow['id'] . '">';
    $row[] = '#' . $aRow['id'];
    $row[] = '<a href="' . admin_url('deals/view/' . $aRow['id']) . '">' . html_entity_decode($aRow['name']) . '</a><div class="row-options"><a href="' . admin_url('deals/view/' . $aRow['id']) . '">' . _l('view') . '</a> | <a href="' . admin_url('deals/edit/' . $aRow['id']) . '">' . _l('edit') . '</a> | <a href="' . admin_url('deals/delete/' . $aRow['id']) . '" class="text-danger _delete">' . _l('delete') . '</a></div>';
    $row[] = html_entity_decode($aRow['company']);
    
    // Combined pipelines / stage / score column (render list)
    if (!empty($aRow['pipeline_relations'])) {
        $parts = explode('; ', $aRow['pipeline_relations']);
        $listHtml = '<ul class="deals-pipeline-relations-list" style="list-style:none;padding:0;margin:0;">';
        foreach ($parts as $p) {
            $p = trim($p);
            if ($p === '') continue;
            $segments = explode(' - ', $p, 3);
            $pipelineName = isset($segments[0]) ? htmlspecialchars($segments[0], ENT_QUOTES, 'UTF-8') : '';
            $stageAndScore = isset($segments[1]) ? htmlspecialchars($segments[1], ENT_QUOTES, 'UTF-8') : '';
            if (isset($segments[2])) {
                $stageAndScore .= ' - ' . htmlspecialchars($segments[2], ENT_QUOTES, 'UTF-8');
            }
            $listHtml .= '<li style="margin-bottom:4px;"><span class="label label-default deals-pipeline-name" style="background:#f0f6ff;color:#09326a;margin-right:6px;padding:3px 6px;border-radius:3px;">' . $pipelineName . '</span>' . $stageAndScore . '</li>';
        }
        $listHtml .= '</ul>';
        $row[] = $listHtml;
    } else {
        $row[] = '-';
    }
    
    $row[] = app_format_money((float)$aRow['deal_value'], get_base_currency());
    $row[] = !empty($aRow['assigned']) ? $aRow['assigned'] : '-';
    $row[] = '<span class="label label-' . ($aRow['status_final'] == 'won' ? 'success' : ($aRow['status_final'] == 'lost' ? 'danger' : 'default')) . '">' . ucfirst($aRow['status_final']) . '</span>';
    $row[] = _dt($aRow['dateadded']);
    
    $output['aaData'][] = $row;
}

echo json_encode($output);
die();