<?php
defined('BASEPATH') or exit('No direct script access allowed');
require_once FCPATH . 'modules/restoration/libraries/PhpWord/PhpWord/Autoloader.php';
\PhpOffice\PhpWord\Autoloader::register();
use PhpOffice\PhpWord\IOFactory;

class Doc_reader extends AdminController {

    public function __construct() {
        parent::__construct();
        $this->load->model('restoration/template_table_model');
    }

    public function index($id) {
        $data['title'] = 'Upload Word Document';
        $data['template_id'] = $id;
        $this->load->view('doc_reader/doc_reader_view', $data);
    }

    public function upload() {
        $uploadPath = FCPATH . 'uploads/restoration_template/';
        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'docx';
        $config['max_size'] = 2048;
        $data['template_id'] = $this->input->post("template_id");

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('docx_file')) {
            $data['error'] = $this->upload->display_errors();
            $this->load->view('doc_reader/doc_reader_view', $data);
        } else {
            $fileData = $this->upload->data();
            $filePath = $uploadPath . $fileData['file_name'];

            try {
                $phpWord = IOFactory::load($filePath);
                $tables = [];
                $tableIndex = 0;

                foreach ($phpWord->getSections() as $section) {
                    foreach ($section->getElements() as $element) {
                        if ($element instanceof \PhpOffice\PhpWord\Element\Table) {
                            $tableData = [];
                            foreach ($element->getRows() as $row) {
                                $rowData = [];
                                foreach ($row->getCells() as $cell) {
                                    $cellText = '';
                                    foreach ($cell->getElements() as $elementInside) {
                                        if (method_exists($elementInside, 'getText')) {
                                            $cellText .= $elementInside->getText() . ' ';
                                        }
                                    }
                                    $rowData[] = trim($cellText);
                                }
                                $tableData[] = $rowData;
                            }
                            $tables[$tableIndex] = $tableData;
                            $tableIndex++;
                        }
                    }
                }

                $data['tables'] = $tables;
                $data['uploaded_doc'] = $filePath;
                $this->load->view('doc_reader/doc_reader_view', $data);

            } catch (Exception $e) {
                $data['error'] = "Error loading Word document: " . $e->getMessage();
                $this->load->view('doc_reader/doc_reader_view', $data);
            }
        }
    }

    public function process_selection() {
        $selectedTables = $this->input->post('tables');
        $selectedColumns = $this->input->post('columns');
        $uploadedDoc = $this->input->post('uploaded_doc');
        $template_id = $this->input->post("template_id");

        if (!$uploadedDoc || !file_exists($uploadedDoc)) {
            echo "Invalid document path.";
            return;
        }

        // Start output buffering
        ob_start();

        echo "<h2>Selected Tables and Columns:</h2>";

        try {
            $phpWord = IOFactory::load($uploadedDoc);
        } catch (Exception $e) {
            die("Error loading Word document: " . $e->getMessage());
        }
        
        $tableIndex = 0;
        
        foreach ($phpWord->getSections() as $section) {
            foreach ($section->getElements() as $element) {
                if ($element instanceof \PhpOffice\PhpWord\Element\Table) {
                    if (in_array($tableIndex, $selectedTables)) {
                        // Arrays for storing data
                        $columnData = [];
                        $rowData = [];
                        $columnsToShow = $selectedColumns[$tableIndex] ?? [];
        
                        echo "<h3>Table #" . ($tableIndex + 1) . "</h3>";
                        echo "<table class='table'>";
        
                        $rowIndex = 0;
        
                        foreach ($element->getRows() as $row) {
                            echo "<tr>";
                            $rowArray = [];
                            $colIndex = 0;
                            foreach ($row->getCells() as $cell) {
                                $cellText = '';
                                foreach ($cell->getElements() as $elementInside) {
                                    if (method_exists($elementInside, 'getText')) {
                                        $cellText .= $elementInside->getText() . ' ';
                                    }
                                }
        
                                $cleanText = htmlspecialchars(trim($cellText));
        
                                // Collect column data for the first row
                                if ($rowIndex == 0) {
                                    if (in_array($colIndex, $columnsToShow)) {
                                        $columnData[] = $cleanText;
                                    }
                                }
        
                                // Collect row data for subsequent rows
                                if ($rowIndex > 0 && in_array($colIndex, $columnsToShow)) {
                                    $rowArray[] = $cleanText;
                                }
        
                                // Show cell only if its column was selected
                                if (in_array($colIndex, $columnsToShow)) {
                                    echo "<td>$cleanText</td>";
                                }
        
                                $colIndex++;
                            }
        
                            // Store row data if not the first row
                            if ($rowIndex > 0 && !empty($rowArray)) {
                                $rowData[] = $rowArray;
                            }
        
                            echo "</tr>";
                            $rowIndex++;
                        }
        
                        echo "</table>";

                        // Adjust column index
                        $columnsNew = [];
                        foreach ($columnData as $index => $value) {
                            $columnsNew[$index + 1] = ["column" => $value, "field" => "text"];
                        }

                        // Adjust row index and inner array index
                        $rowsNew = [];
                        foreach ($rowData as $index => $row) {
                            foreach ($row as $colIndex => $value) {
                                $rowsNew[$colIndex][($index+1)] = $value;  // Inner array index starts from 1
                            }
                        }

                        // Debugging - Display arrays
                        /* echo "<pre>";
                        print_r($columnsNew);
                        print_r($rowsNew);
                        echo "</pre>"; */

                        $template_table_arr = array(
                            "template_id" => $template_id,
                            "field_label" => "Table " . ($tableIndex + 1),
                            "field_type" => "table",
                            "table_column" => count($columnsNew),
                            "table_row" => count($rowsNew[0]),
                            "column_data" => json_encode($columnsNew),
                            "value_data" => json_encode($rowsNew),
                            'is_visible_label' => 1,
                        );
                        $this->template_table_model->add($template_table_arr);

                    }
        
                    $tableIndex++;
                }
            }
        }
        // End output buffering and discard output before redirect
        ob_end_clean();

        // Redirect to the desired page
        redirect(admin_url("restoration/template/builder/".$template_id));
    }
}
