<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends AdminController {

    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $data['title'] = 'Settings';
        $this->load->view('settings/index', $data);
    }

    public function save_settings()
    {
        if ($this->input->post()) {
            $imo_number_label = $this->input->post('restoration_imo_number_label');
            $restoration_email_subject = $this->input->post('restoration_email_subject');
            $restoration_email_body = $this->input->post('restoration_email_body');

            if (!get_option('restoration_imo_number_label')) {
                add_option('restoration_imo_number_label', $imo_number_label);
            } else {
                update_option('restoration_imo_number_label', $imo_number_label);
            }

            if (!get_option('restoration_email_subject')) {
                add_option('restoration_email_subject', $restoration_email_subject);
            } else {
                update_option('restoration_email_subject', $restoration_email_subject);
            }

            if (!get_option('restoration_email_body')) {
                add_option('restoration_email_body', $restoration_email_body);
            } else {
                update_option('restoration_email_body', $restoration_email_body);
            }

            set_alert('success', 'Settings saved successfully.');
        }

        redirect(admin_url('restoration/settings/index'));
    }

}
