<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Template_table_model extends Rest_Base_Model
{
	public function __construct()
    {
        parent::__construct(RESTORATION_TABLE_TEMPLATE_TABLE);
    }

    public function update_value_data($postdata, $FILES){
        $row_data_arr = $postdata['row'] ?? [];
        $uploadedImages = [];
        $uploadPath = FCPATH . 'uploads/restoration_template/'; // Full path to /uploads directory

        // Ensure the upload folder exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0755, true);
        }

        // Loop through the nested $FILES['field']['name']
        // dd($postdata['field'], $FILES['field']);
        if($FILES['field']){
            foreach ($FILES['field']['name'] as $level1Key => $level1) {
                if (is_array($level1)) {
                    foreach ($level1 as $level2Key => $level2) {
                        if (is_array($level2)) {
                            foreach ($level2 as $index => $originalName) {
                                if (!empty($originalName)) {
                                    $extension = pathinfo($originalName, PATHINFO_EXTENSION);
                                    $uniqueName = uniqid('img_', true) . '.' . $extension;
    
                                    $tmpName = $FILES['field']['tmp_name'][$level1Key][$level2Key][$index];
                                    $error   = $FILES['field']['error'][$level1Key][$level2Key][$index];
    
                                    if ($error === UPLOAD_ERR_OK) {
                                        if (move_uploaded_file($tmpName, $uploadPath . $uniqueName)) {
                                            $uploadedImages[$level1Key][$level2Key][$index] = $uniqueName;
                                        }
                                    }
                                }
                            }
                        } else {
                            // If level2 is not array
                            $originalName = $level2;
                            if (!empty($originalName)) {
                                $extension = pathinfo($originalName, PATHINFO_EXTENSION);
                                $uniqueName = uniqid('img_', true) . '.' . $extension;
    
                                $tmpName = $FILES['field']['tmp_name'][$level1Key][$level2Key];
                                $error   = $FILES['field']['error'][$level1Key][$level2Key];
    
                                if ($error === UPLOAD_ERR_OK) {
                                    if (move_uploaded_file($tmpName, $uploadPath . $uniqueName)) {
                                        $uploadedImages[$level1Key][$level2Key] = $uniqueName;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    // If level1 is not array
                    $originalName = $level1;
                    if (!empty($originalName)) {
                        $extension = pathinfo($originalName, PATHINFO_EXTENSION);
                        $uniqueName = uniqid('img_', true) . '.' . $extension;
    
                        $tmpName = $FILES['field']['tmp_name'][$level1Key];
                        $error   = $FILES['field']['error'][$level1Key];
    
                        if ($error === UPLOAD_ERR_OK) {
                            if (move_uploaded_file($tmpName, $uploadPath . $uniqueName)) {
                                $uploadedImages[$level1Key] = $uniqueName;
                            }
                        }
                    }
                }
            }
            $old_data = $postdata['field'];
            foreach ($uploadedImages as $key => $value) {
                // If key exists and both are arrays, merge recursively
                if (isset($postdata['field'][$key]) && is_array($postdata['field'][$key]) && is_array($value)) {
                    foreach ($value as $jkey => $jvalue) {
                        $postdata['field'][$key][$jkey] = $jvalue;    
                    }
                    ksort($postdata['field'][$key]);
                } else {
                    // If not an array or not set, just add/override
                    $postdata['field'][$key] = $value;
                }
            }
        }

        if($postdata['field']){
            foreach ($postdata['field'] as $key => $value) {
                $template = $this->get($key);
                if($template){
                    if($template->value_data){
                        $row_data = json_decode($template->value_data, true);
                        if(is_array($row_data)){
                            foreach ($row_data as $row_key => $row) {
                                if (!array_key_exists($row_key, $value)) {
                                    $value[$row_key] = $row;
                                }
                            }
                        }
                    }
                }
                $this->template_table_model->update($key, ['value_data' => json_encode($value)]);
            }
        }

        if($postdata['row']){
            foreach ($postdata['row'] as $key => $row) {
                $this->template_table_model->update($key, ['row_data' => json_encode($row)]);
            }
        }
        return true;
    }

}
