<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <h3 class="no-margin font-bold"><i class="fa <?php echo $icon ?? '' ?>" aria-hidden="true"></i>Image Edit</h3>
                            </div>
                            <div class="col-md-12"><hr/></div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <input type="file" id="imageUpload" class="form-control" accept="image/*">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <button id="textBtn" class="btn btn-info" onclick="activateTool('text')">Add Text</button>
                                <button id="drawBtn" class="btn btn-info" onclick="activateTool('draw')">Free Draw</button>
                                <label>Color: <input type="color" id="toolColor" value="#FF0000"></label>
                                <label>Size: <input type="range" id="toolSize" min="1" max="10" value="2"></label>
                            </div>
                            <div class="col-md-3">
                                <?php echo form_open_multipart(admin_url('restoration/canvas/save_image'), ['id' => 'form_add_edit']);  ?>
                                <input type="hidden" name="template_id" value="<?php echo $template_id; ?>"> 
                                <button type="submit" class="btn btn-primary">Save to Server</button>
                                <?php echo form_close(); ?>
                            </div>
                            
                            <div class="col-md-12"><hr/></div>
                            <div class="col-md-12 mb-4">
                                <div id="canvas-container">
                                <canvas id="c" width="800" height="600"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.3.0/fabric.min.js"></script>
<script>
    const canvas = new fabric.Canvas('c');
    let activeTool = '';
    let isDrawingMode = false;
    let currentTextObject = null;

    function adjustCanvas(width, height) {
    canvas.clear();
    canvas.setWidth(width);
    canvas.setHeight(height);
    }

    function activateTool(tool) {
    document.querySelectorAll('.controls button').forEach(btn => btn.classList.remove('active-tool'));
    activeTool = tool;
    document.getElementById(tool + 'Btn').classList.add('active-tool');
    deactivateFreeDraw();

    if (tool === 'text') addText();
    else if (tool === 'draw') activateFreeDraw();
    }

    function addText() {
    const color = document.getElementById('toolColor').value;
    const size = parseInt(document.getElementById('toolSize').value);
    const textSize = size * 12;

    const text = new fabric.IText('Enter text...', {
        left: 100, top: 100, fill: color, fontSize: textSize, selectable: true
    });

    canvas.add(text).setActiveObject(text);
    currentTextObject = text;
    }

    function activateFreeDraw() {
    const color = document.getElementById('toolColor').value;
    const size = parseInt(document.getElementById('toolSize').value);
    const lineSize = size / 2;

    canvas.isDrawingMode = true;
    canvas.freeDrawingBrush.color = color;
    canvas.freeDrawingBrush.width = lineSize;
    }

    function deactivateFreeDraw() {
    canvas.isDrawingMode = false;
    }

    document.getElementById('imageUpload').addEventListener('change', uploadImage);

    function uploadImage(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
        const img = new Image();
        img.src = e.target.result;
        img.onload = function() {
            const maxWidth = 800;
            const maxHeight = 600;

            adjustCanvas(maxWidth, maxHeight);

            const imgInstance = new fabric.Image(img, {
            left: 0, top: 0, selectable: false
            });

            const scaleX = maxWidth / img.width;
            const scaleY = maxHeight / img.height;
            const scale = Math.min(scaleX, scaleY);

            imgInstance.set({
            scaleX: scale,
            scaleY: scale
            });
            imgInstance.set({
            left: (canvas.width - imgInstance.getScaledWidth()) / 2,
            top: (canvas.height - imgInstance.getScaledHeight()) / 2
            });

            canvas.setBackgroundImage(imgInstance, canvas.renderAll.bind(canvas));
            canvas.renderAll();
        };
        };
        reader.readAsDataURL(file);
    }
    }

    jQuery(document).ready(() => {
        $('.selectpicker').selectpicker('refresh');

        $("#form_add_edit").appFormValidator({
            rules:{
                // title: 'required',
                // category:'required',
            },
            errorPlacement: function(error, element) {
                $(error).addClass('text-danger');
                error.appendTo( element.parents(".form-group"));
            },
            submitHandler: function(form) {
                add_edit_form_handler(form);
            },
            highlight: function(element, errorClass) {
                $(element).parents('.form-group').addClass("has-error");
            }
        });

    });

    function add_edit_form_handler(form){
        $("#add_loader").removeClass('d-none');
        let formURL = form.action;
        let formData = new FormData($(form)[0]);
        
        // Get the canvas image data as a dataURL
        const dataURL = canvas.toDataURL('image/png');
        formData.append('image', dataURL); // Add dataURL to FormData

        $.ajax({
            type: $(form).attr('method'),
            data: formData,
            mimeType: $(form).attr('enctype'),
            contentType: false,
            cache: false,
            processData: false,
            url: formURL
        }).done(function (response) {
            $("#add_loader").addClass('d-none');
            response = JSON.parse(response);
            if (response.success === true || response.success == 'true') {
                alert_float('success', response.message);
                window.location = '<?= admin_url('restoration/template/builder/'.$template_id); ?>';
            } else {
                alert_float('danger', response.message);
            }

        }).fail(function (error) {
            alert_float('danger', JSON.parse(error.responseText));
        });
    }

    function saveImage() {
    const dataURL = canvas.toDataURL('image/png');
    fetch('<?= admin_url('restoration/canvas/save_image'); ?>', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ image: dataURL })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) alert('Image saved as ' + data.filename);
        else alert('Failed to save image.');
    })
    .catch(error => console.error('Error:', error));
    }
</script>

