<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<p class="project-info tw-mb-0 tw-font-medium tw-text-base tw-tracking-tight">
    <?= _l('project_progress_text'); ?>
    <span
        class="tw-text-neutral-500 tw-text-sm"><?= e($percent); ?>%</span>
</p>
<div class="progress progress-bar-mini">
    <div class="progress-bar progress-bar-success no-percent-text not-dynamic" role="progressbar"
        aria-valuenow="<?= e($percent); ?>" aria-valuemin="0"
        aria-valuemax="100" style="width: 0%"
        data-percent="<?= e($percent); ?>">
    </div>
</div>
<?php hooks()->do_action('admin_area_after_project_progress') ?>

<div class="panel_s tw-relative">
    <div
        class="tw-absolute tw-bg-neutral-300 tw-h-full tw-w-px tw-top-1/2 tw-left-1/2 tw-transform -tw-translate-x-1/2 -tw-translate-y-1/2 tw-z-10 tw-hidden sm:tw-block">
    </div>
    <div class="panel-body">
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-2 tw-gap-y-6 tw-gap-x-12">
            <div class="project-overview-left">

                <?php if (count($project->shared_vault_entries) > 0) { ?>
                <?php $this->load->view('restoration/projects/_project_vault_entries'); ?>
                <?php } ?>

                <h4 class="tw-font-semibold tw-text-neutral-700 tw-text-base tw-mt-0 tw-mb-4">
                    <?= _l('project_overview'); ?>
                </h4>

                <?php $this->load->view('restoration/projects/_project_overview_description_list'); ?>

                <?php hooks()->do_action('admin_project_overview_end_of_project_overview_left', $project) ?>
            </div>
            <div class="project-overview-right tw-space-y-8">
                <div>
                    <h4 class="tw-font-semibold tw-text-neutral-700 tw-text-base tw-mt-0 tw-mb-4">
                        <?= e($project->name); ?>
                    </h4>
                    <div class="tw-grid tw-grid-cols-2 tw-gap-4 project-progress-bars">
                        <?php if ($project->deadline) { ?>
                        <div
                            class="project-progress-bars project-overview-days-left tw-border tw-border-solid tw-border-neutral-300/80 tw-rounded-lg tw-py-2.5 tw-px-3">
                            <p class="tw-text-neutral-700 tw-font-semibold tw-mb-1 tw-text-sm">
                                <span
                                    dir="ltr"><?= e($project_days_left); ?>
                                    /
                                    <?= e($project_total_days); ?></span>
                                <?= _l('project_days_left'); ?>
                            </p>
                            <p class="tw-text-neutral-400 tw-font-normal tw-mb-0 tw-text-sm">
                                <?= e($project_time_left_percent); ?>%
                            </p>

                            <div class="tw-mt-1">
                                <div class="progress no-margin progress-bar-mini">
                                    <div class="progress-bar no-percent-text not-dynamic <?= ($project_time_left_percent == 0) ? 'progress-bar-warning' : 'progress-bar-success'; ?>"
                                        role="progressbar"
                                        aria-valuenow="<?= e($project_time_left_percent); ?>"
                                        aria-valuemin="0" aria-valuemax="100" style="width: 0%"
                                        data-percent="<?= e($project_time_left_percent); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php if (isset($project_overview_chart)) { ?>
<script>
    var
        project_overview_chart = <?= json_encode($project_overview_chart); ?> ;
</script>
<?php } ?>