<style>
    body { font-family: Arial, sans-serif; }
    
    /* Main table styling */
    table { 
        border-collapse: collapse; 
        width: 100%; 
        background-color: #ffffff; 
    }

    /* Header styling */
    th {
        padding: 12px;
        text-align: left;
        background-color: #0073e6;
        color: #ffffff;
        border: 1px solid #005bb5;
        font-size: 14px;
    }

    /* Cell styling */
    td {
        padding: 10px;
        border: 1px solid #ddd;
        font-size: 13px;
        color: #333;
    }

    /* Alternative row background */
    tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    /* Image styling */
    img {
        max-width: 100%;
        height: auto;
    }

    /* Section headers */
    .section-header {
        background-color: #f0f0f0;
        padding: 10px;
        font-size: 16px;
        font-weight: bold;
        border-left: 5px solid #0073e6;
    }

    /* Conclusion section */
    .conclusion {
        background-color: #0073e6;
        color: white;
        padding: 10px;
        font-weight: bold;
    }

    /* Notes text */
    .notes {
        padding: 10px;
        background-color: #f8f9fa;
        border: 1px solid #ddd;
        border-radius: 5px;
    }
</style>

<?php
if ($tasks) {
    foreach ($tasks as $key => $task) {
        if ($task["template_table"]) {
            $template_table = $task["template_table"];
?>
            <table>
                <tbody>
                    <?php
                    if ($template_table) {
                        foreach ($template_table as $key => $value) {
                    ?>
                            <tr>
                                <td>
                                    <?php
                                    if ($value['field_type'] == 'table') {
                                    ?>
                                        <table>
                                            <?php if ($value['is_visible_label'] == 1) { ?>
                                            <thead>
                                                <tr>
                                                    <?php
                                                    $columnWidth = 100 / count($value["column_data"]);
                                                    foreach ($value["column_data"] as $column_key => $column_value) {
                                                    ?>
                                                        <th style="width: <?= $columnWidth ?>%;"><?= $column_value['column']; ?></th>
                                                    <?php
                                                    }
                                                    ?>
                                                </tr>
                                            </thead>
                                            <?php } ?>
                                            <tbody>
                                                <?php
                                                $columnWidth = 100 / count($value["column_data"]);
                                                $i = 1;
                                                while ($value['table_row'] >= $i) {
                                                    $j = 0;
                                                ?>
                                                    <tr>
                                                        <?php
                                                        foreach ($value["column_data"] as $column_key => $column_value) {
                                                        ?>
                                                            <td style="width: <?= $columnWidth ?>%;">
                                                                <?php
                                                                switch ($column_value['field']) {
                                                                    case 'fields':
                                                                        $selected = isset($value['value_data'][$j][$i]) ? $value['value_data'][$j][$i] : '';
                                                                        switch ($value['row_data'][$j][$i]) {
                                                                            case 'textarea':
                                                                                echo $value['value_data'][$j][$i];
                                                                                break;
                                                                            default:
                                                                                echo '<p>' . $value['value_data'][$j][$i] . '</p>';
                                                                                break;
                                                                        }
                                                                        break;
                                                                    case 'textarea':
                                                                        echo $value['value_data'][$j][$i];
                                                                        break;
                                                                    case 'file':
                                                                        echo '<img src="' . site_url('uploads/restoration_template/' . $value['value_data'][$j][$i]) . '" class="img-fluid" alt="Image">';
                                                                        break;
                                                                    default:
                                                                        echo '<p>' . $value['value_data'][$j][$i] . '</p>';
                                                                        break;
                                                                }
                                                                $j++;
                                                                ?>
                                                            </td>
                                                        <?php
                                                        }
                                                        ?>
                                                    </tr>
                                                <?php
                                                    $i++;
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    <?php
                                    } else {
                                        switch ($value['value_data']) {
                                            case 'text':
                                                echo render_input('field[' . $value["id"] . ']', '', '', 'text');
                                                break;
                                            case 'textarea':
                                                echo render_textarea('field[' . $value["id"] . ']', '', '', [], [], '', 'tinymce');
                                                break;
                                            case 'number':
                                                echo render_input('field[' . $value["id"] . ']', '', '', 'number');
                                                break;
                                            case 'file':
                                                echo '<div class="form-group">
                                                        <input type="file" name="field[' . $value["id"] . ']" class="form-control" id="profile_image">
                                                    </div>';
                                                break;
                                            default:
                                                switch ($value["field_type"]) {
                                                    case 'textarea':
                                                        echo $value['value_data'];
                                                        break;
                                                    case 'file':
                                                        echo '<img src="' . site_url('uploads/restoration_template/' . $value['value_data']) . '" class="img-fluid" alt="">';
                                                        break;
                                                    default:
                                                        echo '<p>' . $value['value_data'] . '</p>';
                                                        break;
                                                }
                                                break;
                                        }
                                    }
                                    ?>
                                </td>
                            </tr>
                    <?php
                        }
                    }
                    if ($staff_notes) {
                    ?>
                        <tr>
                            <td>
                                <table>
                                    <tbody>
                                        <tr>
                                            <th class="conclusion">Conclusion</th>
                                        </tr>
                                        <tr>
                                            <td class="notes"><?= $staff_notes; ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        <?php
        }
    }
} else {
?>
    <p>No report found</p>
<?php
}
?>
